/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructureBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class BCLStructure<S extends Structure> {
    protected final GenerationStep.Decoration featureStep;
    protected final List<ResourceLocation> biomes = Lists.newArrayList();
    protected final ResourceLocation id;
    public final TagKey<Biome> biomeTag;
    public final ResourceKey<Structure> structureKey;
    public final ResourceKey<StructureSet> structureSetKey;
    public final StructurePlacement spreadConfig;
    public final StructureType<S> structureType;
    private boolean registeredSet = false;

    private static HolderSet<Biome> biomes(BootstapContext<Structure> bootstrapContext, TagKey<Biome> tagKey) {
        return bootstrapContext.m_255420_(Registries.f_256952_).m_254956_(tagKey);
    }

    private static Structure.StructureSettings structure(BootstapContext<Structure> bootstrapContext, TagKey<Biome> tagKey, Map<MobCategory, StructureSpawnOverride> map, GenerationStep.Decoration decoration, TerrainAdjustment terrainAdjustment) {
        return new Structure.StructureSettings(BCLStructure.biomes(bootstrapContext, tagKey), map, decoration, terrainAdjustment);
    }

    private static Structure.StructureSettings structure(BootstapContext<Structure> bootstrapContext, TagKey<Biome> tagKey, GenerationStep.Decoration decoration, TerrainAdjustment terrainAdjustment) {
        return BCLStructure.structure(bootstrapContext, tagKey, Map.of(), decoration, terrainAdjustment);
    }

    private static <S extends Structure> StructureType<S> registerStructureType(ResourceLocation id, Codec<S> codec) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256938_, (ResourceLocation)id);
        return (StructureType)Registry.m_194579_((Registry)BuiltInRegistries.f_256763_, (ResourceKey)key, () -> codec);
    }

    protected BCLStructure(@NotNull ResourceLocation id, @NotNull ResourceKey<Structure> structureKey, @NotNull ResourceKey<StructureSet> structureSetKey, @NotNull GenerationStep.Decoration step, @NotNull StructurePlacement placement, @NotNull TagKey<Biome> biomeTag, @NotNull StructureType<S> structureType) {
        this.id = id;
        this.featureStep = step;
        this.spreadConfig = placement;
        this.structureKey = structureKey;
        this.structureSetKey = structureSetKey;
        this.biomeTag = biomeTag;
        this.structureType = structureType;
    }

    public static boolean isValidBiome(Structure.GenerationContext context) {
        return BCLStructure.isValidBiome(context, 5);
    }

    public static boolean isValidBiome(Structure.GenerationContext context, int yPos) {
        BlockPos blockPos = context.f_226628_().m_151394_(yPos);
        return context.f_226630_().test(context.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)blockPos.m_123341_()), QuartPos.m_175400_((int)blockPos.m_123342_()), QuartPos.m_175400_((int)blockPos.m_123343_()), context.f_226624_().m_224579_()));
    }

    public GenerationStep.Decoration getFeatureStep() {
        return this.featureStep;
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public void addInternalBiome(ResourceLocation biome) {
        this.biomes.add(biome);
    }

    public List<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    public void registerSet(BootstapContext<StructureSet> bootstrapContext) {
        if (this.registeredSet) {
            return;
        }
        this.registeredSet = true;
        bootstrapContext.m_255272_(this.structureSetKey, (Object)new StructureSet((Holder)bootstrapContext.m_255420_(Registries.f_256944_).m_255043_(this.structureKey), this.spreadConfig));
        BCLStructureBuilder.UNBOUND_STRUCTURE_SETS.remove(this);
    }

    public abstract Bound<S> register(BootstapContext<Structure> var1);

    public static class Bound<S extends Structure>
    extends BCLStructure<S> {
        public final S baseStructure;
        public final Holder<Structure> structure;

        private Bound(@NotNull ResourceLocation id, @NotNull ResourceKey<Structure> structureKey, @NotNull ResourceKey<StructureSet> structureSetKey, @NotNull GenerationStep.Decoration featureStep, @NotNull StructurePlacement placement, @NotNull TagKey<Biome> biomeTag, @NotNull StructureType<S> structureType, @NotNull S baseStructure, @NotNull Holder<Structure> structure) {
            super(id, structureKey, structureSetKey, featureStep, placement, biomeTag, structureType);
            this.baseStructure = baseStructure;
            this.structure = structure;
        }

        public Holder<Structure> getStructure() {
            return this.structure;
        }

        @Override
        public Bound<S> register(BootstapContext<Structure> bootstrapContext) {
            return this;
        }
    }

    public static class Unbound<S extends Structure>
    extends BCLStructure<S> {
        private final StructureBuilder<S> structureBuilder;
        private final TerrainAdjustment terrainAdjustment;
        private Bound<S> registered = null;

        protected Unbound(@NotNull ResourceLocation id, @NotNull GenerationStep.Decoration step, @NotNull StructurePlacement placement, @NotNull Codec<S> codec, @NotNull TagKey<Biome> biomeTag, @NotNull StructureBuilder<S> structureBuilder, @NotNull TerrainAdjustment terrainAdjustment) {
            super(id, (ResourceKey<Structure>)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)id), (ResourceKey<StructureSet>)ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)id), step, placement, biomeTag, BCLStructure.registerStructureType(id, codec));
            this.structureBuilder = structureBuilder;
            this.terrainAdjustment = terrainAdjustment;
        }

        @Override
        public Bound<S> register(BootstapContext<Structure> bootstrapContext) {
            S baseStructure;
            if (this.registered != null) {
                return this.registered;
            }
            Structure.StructureSettings settings = BCLStructure.structure(bootstrapContext, (TagKey<Biome>)this.biomeTag, this.featureStep, this.terrainAdjustment);
            StructureBuilder<S> structureBuilder = this.structureBuilder;
            if (structureBuilder instanceof StructureBuilderWithContext) {
                StructureBuilderWithContext sctx = (StructureBuilderWithContext)structureBuilder;
                baseStructure = sctx.apply(settings, bootstrapContext);
            } else {
                baseStructure = this.structureBuilder.apply(settings);
            }
            Holder.Reference structure = bootstrapContext.m_255272_(this.structureKey, baseStructure);
            BCLStructureBuilder.UNBOUND_STRUCTURES.remove(this);
            this.registered = new Bound<S>(this.id, (ResourceKey<Structure>)this.structureKey, (ResourceKey<StructureSet>)this.structureSetKey, this.featureStep, this.spreadConfig, (TagKey<Biome>)this.biomeTag, this.structureType, baseStructure, (Holder<Structure>)structure);
            return this.registered;
        }
    }

    public static interface StructureBuilderWithContext<S extends Structure>
    extends StructureBuilder<S> {
        @Override
        default public S apply(Structure.StructureSettings structureSettings) {
            return this.apply(structureSettings, null);
        }

        public S apply(Structure.StructureSettings var1, BootstapContext<Structure> var2);
    }

    public static interface StructureCodecProvider<S extends Structure> {
        public Codec<S> getCodec();
    }

    public static interface StructureBuilder<S extends Structure> {
        public S apply(Structure.StructureSettings var1);
    }
}

